﻿using System.Collections;
using System.Collections.Generic;
using TMPro;
using UnityEngine;

//GameHUD manages the entire game HUD
public class GameHUD : MonoBehaviour
{
    //UI Elements
    public GameObject GameHUDUI;
    public GameObject StreetNameFlyout;
    public GameObject MoneyFlyout;

    private StreetFlyoutController _StreetFlyoutController;
    private MoneyFlyoutController _MoneyFlyoutController;

    public void Start()
    {
        //Get our controllers
        _StreetFlyoutController = StreetNameFlyout.GetComponent<StreetFlyoutController>();
        _MoneyFlyoutController = MoneyFlyout.GetComponent<MoneyFlyoutController>();
    }

    public void Update()
    {
        if(GameManager.Instance.GameState != Constants.GameState.Playing)
        {
            //We're not playing, hide the UI
            GameHUDUI.SetActive(false);
        }

        else
        {
            //We're playing, show the UI and update the controller values
            GameHUDUI.SetActive(true);
            UpdateStreetName();
            _MoneyFlyoutController.UpdateMoney(GameManager.Instance.Money);
        }
    }

    /// <summary>
    /// Updates the street name based on the player's current position
    /// </summary>
    private void UpdateStreetName()
    {
        string streetName = StreetsManager.Instance.GetCurrentStreetName();

        if (!string.IsNullOrEmpty(streetName))
        {
            _StreetFlyoutController.UpdateStreetName(streetName);
        }
    }
}
